#!/usr/bin/env python

from import_executor import ImportExecutor
from retrieve_preprocessor import RetrievePreprocessor
from store_preprocessor import StorePreprocessor
from retrieve_executor import RetrieveExecutor
from store_executor import StoreExecutor



class JobScheduler(object):

    def __init__(self):
        self.importExecutor = ImportExecutor()
        self.retrievePreprocessor = RetrievePreprocessor()
        self.storePreprocessor = StorePreprocessor()
        self.retrieveExecutor = RetrieveExecutor()
        self.storeExecutor = StoreExecutor()

    def start(self):
        self.importExecutor.start()
        self.retrievePreprocessor.start()
        self.storePreprocessor.start()
        self.retrieveExecutor.start()
        self.storeExecutor.start()
