import json
import redis
import uuid

class RedisRpcClient(object):

    def __init__(self, redisHost, listName):
        self.client = redis.Redis(redisHost)
        self.listName = listName

    def send(self):
        print("Sending RPC request")
        request = {
          "jsonrpc": "2.0",
          "id": uuid.uuid1().hex
        }

        self.client.lpush(self.listName, json.dumps(request))
        channel, response = self.client.brpop(request["id"], timeout = 30)
        response = json.loads(response.decode("utf-8"))
        print(response)


client = RedisRpcClient("job_cache", "testList")
client.send()
