import json
import redis
import threading


class RedisRPCServer(threading.Thread):

    def __init__(self, host, port, db, rpcQueue):
        threading.Thread.__init__(self)
        self.redisUrl = "redis://" + host + ':' + str(port) + '/' + str(db)
        self.client = redis.from_url(self.redisUrl)
        self.rpcQueue = rpcQueue

    def run(self):
        while True:
            channel, request = self.client.brpop(self.rpcQueue)
            channel = channel.decode("utf-8")
            request = json.loads(request.decode("utf-8"))
            response = self.callback(request)
            self.client.rpush(request["id"], json.dumps(response))
            self.client.expire(request["id"], 30)

    def callback(self, request):
        """
        This method must be implemented by
        inherited classes
        """
        pass
