#!/usr/bin/env python

import json
import urllib
from base64 import b64encode
from http.client import HTTPSConnection
from http.client import HTTPException

from config import Config
from exceptions import MultipleUsersException


class RapClient(object):

    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("authentication")
        self.client = params["rap_client"]
        self.secret = params["rap_secret"]
        self.ssoServer = params["sso_server"]

    def getUserInfo(self, username):
        try:
            # Obtain OAuth2 token from client credentials
            conn = HTTPSConnection(self.ssoServer)
            params = urllib.parse.urlencode({"grant_type": "client_credentials"})
            headers = {
                "Content-type": "application/x-www-form-urlencoded",
                "Authorization": "Basic " + b64encode(str.encode(self.client + ":" + self.secret)).decode()
            }
            conn.request("POST", "/rap-ia2/auth/oauth2/token", params, headers)
            response = conn.getresponse()
            response_body = response.read()
        except HTTPException:
            raise
        else:
            try:
                tokenInfo = json.loads(response_body.decode())
                accessToken = tokenInfo["access_token"]

                # Obtain user info from RAP service
                email = username + "@inaf.it"
                headers = {
                    "Authorization": "Bearer " + accessToken
                }
                conn.request("GET", "/rap-ia2/ws/user?search=" + urllib.parse.quote(email), None, headers)
                response = conn.getresponse()
                responseBody = response.read()
            except HTTPException:
                raise
            else:
                userInfo = json.loads(responseBody.decode())

                if len(userInfo) == 0:
                    return None

                if len(userInfo) > 1:
                    raise MultipleUsersException

                for idn in userInfo[0]["identities"]:
                    if idn["institution"] and "INAF" in idn["institution"]:
                        eppn = idn["eppn"]

                if eppn != email:
                    return None

                userInfo[0]["email"] = email

                return userInfo[0]
            finally:
                conn.close()
        finally:
            conn.close()
        

#rapClient = RapClient()
#userInfo = rapClient.getUserInfo("")
#print(userInfo["id"])
#print(userInfo)
#print(userInfo is None)