#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import sys

from datetime import datetime as dt


class Node(object):

    def __init__(self, name, type):
        self.parentPath = None
        self.name = name
        self.wrapperDir = None
        self.type = type
        self.locationId = None
        self.format = None
        self.asyncTrans = False
        self.sticky = False
        self.jobId = None
        self.creatorId = None
        self.groupRead = []
        self.groupWrite = []
        self.visibility = False
        self.delta = None
        self.contentType = None
        self.contentEncoding = None
        self.contentLength = None
        self.contentMD5 = None
        self.acceptViews = []
        self.provideViews = []
        self.protocols = []
        # used only in case of update
        self.lastModified = dt.now().strftime("%Y-%m-%d %H:%M:%S")

        self.types = [ "container", "data", "link" ]

    """
    Getters
    """




    """
    Setters
    """

    def setParentPath(self, parentPath):
        self.parentPath = parentPath

    def setName(self, name):
        self.name = name
        
    def setWrapperDir(self, wrapperDir):
        self.wrapperDir = wrapperDir

    def setType(self, type):
        if type in self.types:
            self.type = type
        else:
            sys.exit(f"FATAL: Invalid type {type}")
            
    def setLocationId(self, locationId):
        self.locationId = locationId

    def setFormat(self, format):
        self.format = format

    def setAsyncTrans(self, asyncTrans):
        self.asyncTrans = asyncTrans
        
    def setSticky(self, sticky):
        self.sticky = sticky

    def setJobId(self, jobId):
        self.jobId = jobId

    def setCreatorId(self, creatorId):
        self.creatorId = creatorId

    def setGroupRead(self, groupRead):
        self.groupRead = groupRead

    def setGroupWrite(self, groupWrite):
        self.groupWrite = groupWrite

    # 'isPubilc' flag
    def setVisibility(self, visibility):
        self.visibility = visibility

    def setContentType(self, contentType):
        self.contentType = contentType

    def setContendEncoding(self, contentEncoding):
        self.contentEncoding = contentEncoding

    def setContentLength(self, contentLength):
        self.contentLength = contentLength

    def setContentMD5(self, contentMD5):
        self.contentMD5 = contentMD5
