#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import redis
import logging

from config import Config

from redis.exceptions import ConnectionError


class RedisLogHandler(object):
    """
    Log handler for sending log records to a Redis queue.
    """
    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("job_cache")
        self.redisCli = redis.Redis(host = params["host"],
                                    port = params["port"],
                                    db = params["db_sched"])
        params = config.loadSection("logging")
        self.logQueue = params["log_queue"]
        logLevel = "logging." + params["log_level"]
        self.level = eval(logLevel)
        self.formatter = logging.Formatter()

    def handle(self, record):
        try:
            self.redisCli.lpush(self.logQueue, self.formatter.format(record))
        except ConnectionError:
            # Redis is not responding...
            pass
        except Exception:
            raise

    def setFormatter(self, formatter):
        self.formatter = formatter
