#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import sys
import time

from start_job_rpc_server import StartJobRPCServer
from abort_job_rpc_server import AbortJobRPCServer


class VOSpaceRestHandler(object):

    def __init__(self, host, port, db):
        self.host = host
        self.port = port
        self.db = db
        self.rpcServerList = []

    def addRPCServer(self, srvType, rpcQueue):
        if srvType == 'start':
            self.rpcServerList.append(StartJobRPCServer(self.host, self.port, self.db, rpcQueue))
        elif srvType == 'abort':
            self.rpcServerList.append(AbortJobRPCServer(self.host, self.port, self.db, rpcQueue))
        else:
            sys.exit(f"FATAL: unknown server type {srvType}.")

    def start(self):
        for srv in self.rpcServerList:
            srv.start()
        running = False
        while not running:            
            time.sleep(1)
            running = True
            for srv in self.rpcServerList:
                running &= srv.is_alive()
