import root from 'raw-loader!./data/nodes/root.html';
import folder1 from 'raw-loader!./data/nodes/folder1.html';
import folder2 from 'raw-loader!./data/nodes/folder2.html';
import job from './data/job';
import jobs from './data/jobs';
import user from './data/user';

import store from '../../store';

const fetch = (mockData, showLoading = true, time = 500) => {
  return new Promise((resolve) => {
    if (showLoading) {
      store.commit('setLoading', true);
    }
    setTimeout(() => {
      resolve(mockData)
      if (showLoading) {
        store.commit('setLoading', false);
      }
    }, time);
  });
};

export default {
  getNode(path) {
    let response;
    switch (path) {
      case '':
        response = root;
        break;
      case 'folder1':
        response = folder1;
        break;
      case 'folder1/folder2':
        response = folder2;
        break;
    }
    return fetch(response);
  },
  startAsyncRecallJob() {
    return fetch(job);
  },
  loadJobs() {
    return fetch(jobs, false);
  },
  getUserInfo() {
    return fetch(user, false);
  },
  createFolder() {
    return fetch({});
  },
  prepareForUpload() {
    return fetch(['http://fileservice/upload']);
  },
  uploadFile() {
    return fetch({});
  }
}
