import store from './store.js'
import client from 'api-client'

let lastResultTime = null;
let times = 0;

function checkNodes() {
  let busyNodes = document.getElementsByClassName('node-busy').length > 0;
  let jobsInProgress = store.state.jobs.filter(j => j.phase === 'EXECUTING').length > 0;
  if (!busyNodes && !jobsInProgress) {
    // reset state
    lastResultTime = null;
    times = 0;
    return;
  }
  if (lastResultTime !== null) {
    // first 10 times check every second, then check every ten seconds
    let offset = times < 10 ? 1000 : 10000;
    let now = new Date().getTime();
    if (now - lastResultTime < offset) {
      return;
    }
  }

  if (!store.state.nodesLoading) {
    let path = store.state.path;
    store.commit('setNodesLoading', true);
    client.getNode(path, false)
      .then(res => {
        // check that path didn't change in meantime by user action
        if (path === store.state.path) {
          let resHasBusyNodes = res.htmlTable.includes('node-busy');
          if ((!busyNodes && resHasBusyNodes) || (busyNodes && !resHasBusyNodes)) {
            store.dispatch('setNodes', res);
          } else {
            times++;
            lastResultTime = new Date().getTime();
          }
        }
      })
      .finally(() => {
        store.commit('setNodesLoading', false);
      });
  }
}

export default {
  checkNodes
}
