package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.service.NodesService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.verify;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@ExtendWith(MockitoExtension.class)
public class NodesControllerTest {

    @Mock
    private NodesService nodesService;

    @InjectMocks
    private NodesController controller;

    private MockMvc mockMvc;

    @BeforeEach
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testListNodesEmpty() throws Exception {

        mockMvc.perform(get("/nodes"))
                .andExpect(status().isOk());

        verify(nodesService).generateNodesHtml(eq("/"));
    }

    @Test
    public void testListNodesRoot() throws Exception {

        mockMvc.perform(get("/nodes/"))
                .andExpect(status().isOk());

        verify(nodesService).generateNodesHtml(eq("/"));
    }

    @Test
    public void testListNodesComplexPath() throws Exception {

        mockMvc.perform(get("/nodes/a/b/c"))
                .andExpect(status().isOk());

        verify(nodesService).generateNodesHtml(eq("/a/b/c"));
    }
}
