const BASE_API_URL = process.env.VUE_APP_API_BASE_URL;

import axios from 'axios';

function apiRequest(options, showLoading = true, handleValidationErrors = false) {
  if (showLoading) {
    loading(true);
  }
  return new Promise((resolve, reject) => {
    axios(options)
      .then(response => {
        if (response.status === 204) {
          resolve({});
        } else {
          resolve(response.data);
        }
        loading(false);
      })
      .catch(error => {
        loading(false);
        if (handleValidationErrors && error.response && error.response.status === 400) {
          reject(error.response.data);
        } else {
          dispatchApiErrorEvent(error);
        }
      });
  });
}

function dispatchApiErrorEvent(error) {
  let event = new CustomEvent('apiError');
  let errorMessage;
  if (error.response && error.response.data && error.response.data.message) {
    errorMessage = error.response.data.message;
  } else if (error.message) {
    errorMessage = error.message;
  } else {
    errorMessage = 'Unknown error';
  }
  event.message = {
    title: error.error || 'Error',
    body: errorMessage
  };
  document.dispatchEvent(event);
}

/* For loading animation */
function loading(value) {
  let event = new CustomEvent('loading');
  event.value = value;
  document.dispatchEvent(event);
}

export default {
  getNode(path) {
    let url = BASE_API_URL + 'nodes/' + path;
    return apiRequest({
      method: 'GET',
      url: url,
      withCredentials: true,
      headers: {
        'Cache-Control': 'no-cache'
      }
    }, true, true);
  }
}
