/* Vuex store, for centralized state management */

import Vue from 'vue';
import Vuex from 'vuex';
import client from 'api-client';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    //breadcrumbs: [],
    path: '',
    loading: true
  },
  mutations: {
    setLoading(state, loading) {
      state.loading = loading;
    },
    setPath(state, value) {
      if (!value) {
        value = '';
      }
      state.path = value;
      //state.breadcrumbs = value.split('/')
    }
  },
  actions: {
    setPath({ state, commit }, path) {
      commit('setPath', path);
      client.getNode(state.path)
        .then(res => {
          document.getElementById('nodes').outerHTML = res
        });
    }
  }
});
