package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.aa.UserManager;
import it.inaf.ia2.aa.data.User;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
public class UserController {

    @Autowired
    private UserManager userManager;

    @GetMapping(value = "/user", produces = MediaType.APPLICATION_JSON_VALUE)
    public Map<String, String> getUserInfo(HttpSession session) {
        User user = (User) session.getAttribute("user_data");
        String username = user == null ? "anonymous" : user.getUserLabel();
        Map<String, String> response = new HashMap<>();
        response.put("username", username);
        return response;
    }

    @GetMapping(value = "/keepalive", produces = MediaType.APPLICATION_JSON_VALUE)
    public void refresh(HttpSession session, HttpServletRequest request) {
        User user = (User) session.getAttribute("user_data");
        if (user != null && user.getExpiresIn() < 120) {
            userManager.refreshToken(request);
        }
    }

    // NOTE: endpoint /logout is defined by Spring and it trigger a login again, so /vospace-logout is used
    @GetMapping(value = "/vospace-logout", produces = MediaType.TEXT_HTML_VALUE)
    public void index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        if (session != null) {
            session.invalidate();
        }
        String baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        response.sendRedirect(baseUrl);
    }
}
