/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui;

import it.inaf.ia2.aa.data.User;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

/**
 * Extracts user from the session and set it as request Principal.
 */
public class UserFilter implements Filter {

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        HttpServletRequestWrapper requestWithPrincipal = new RequestWithPrincipal((HttpServletRequest) req);
        fc.doFilter(requestWithPrincipal, res);
    }

    private static class RequestWithPrincipal extends HttpServletRequestWrapper {

        private final User user;

        public RequestWithPrincipal(HttpServletRequest request) {
            super(request);
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("user_data") == null) {
                this.user = new User()
                        .setUserId("anonymous").setUserLabel("Anonymous")
                        .setGroups(new ArrayList<>());
            } else {
                this.user = (User) session.getAttribute("user_data");
            }
        }

        @Override
        public Principal getUserPrincipal() {
            return user;
        }
    }
}
