/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.vospace.ui.exception.BadRequestException;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseController {

    @Autowired
    private HttpSession session;

    protected User getUser() {
        return (User) session.getAttribute("user_data");
    }

    protected String getRequiredParam(Map<String, Object> params, String key) {
        if (!params.containsKey(key)) {
            throw new BadRequestException("Missing mandatory parameter " + key);
        }
        return (String) params.get(key);
    }

    protected <T> T getRequiredParam(Map<String, Object> params, String key, Class<T> type) {
        if (!params.containsKey(key)) {
            throw new BadRequestException("Missing mandatory parameter " + key);
        }
        return (T) params.get(key);
    }
}
