/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.data;

import java.text.SimpleDateFormat;
import javax.xml.datatype.XMLGregorianCalendar;
import net.ivoa.xml.uws.v1.ExecutionPhase;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.uws.v1.ShortJobDescription;

public class Job {

    public static enum JobType {
        ASYNC_RECALL,
        ARCHIVE,
        MOVE,
        COPY
    }

    private String id;
    private String creationTime;
    private ExecutionPhase phase;
    private boolean read;
    private JobType type;

    public Job() {
    }

    public Job(JobSummary job, JobType type) {
        this.id = job.getJobId();
        this.creationTime = formatCreationTime(job.getCreationTime());
        this.phase = job.getPhase();
        this.type = type;
    }

    public Job(ShortJobDescription job, JobType type) {
        this.id = job.getId();
        this.creationTime = formatCreationTime(job.getCreationTime());
        this.phase = job.getPhase();
        this.type = type;
    }

    private String formatCreationTime(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(calendar.toGregorianCalendar().getTime());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public ExecutionPhase getPhase() {
        return phase;
    }

    public void setPhase(ExecutionPhase phase) {
        this.phase = phase;
    }

    public boolean isRead() {
        return read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public JobType getType() {
        return type;
    }

    public void setType(JobType type) {
        this.type = type;
    }
}
