/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
import VueRouter from 'vue-router';

import Main from './components/Main.vue';
import Jobs from './components/Jobs.vue';
import Collections from './components/Collections.vue'

export default new VueRouter({
    routes: [{
            path: '/',
            redirect: '/nodes/'
        }, {
            name: 'nodes',
            path: '/nodes/:path(.*)',
            component: Main
        }, {
            path: '/jobs',
            component: Jobs
        }, {
            path: '/collections',
            component: Collections
        }]
})
