package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.service.NodesService;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NodesController {

    @Autowired
    private NodesService nodesService;

    /**
     * This is the only API endpoint that returns HTML code instead of JSON. The
     * reason is that JavaScript frameworks are not very efficient in handling
     * very long lists and tables, so this part of the code is generated
     * server-side.
     */
    @GetMapping(value = {"/nodes", "/nodes/{path}"}, produces = MediaType.TEXT_HTML_VALUE)
    public void listNodes(@PathVariable(value = "path", required = false) String path, HttpServletResponse response) throws Exception {

        if (path == null || path.isBlank()) {
            path = "/";
        }

        nodesService.generateNodesHtml(path, response.getOutputStream());
    }
}
