package it.inaf.ia2.vospace.ui.service;

import it.inaf.ia2.vospace.ui.VOSpaceException;
import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NodesService {

    @Autowired
    private VOSpaceClient client;

    @Value("${vospace-authority}")
    private String authority;

    public void generateNodesHtml(String path, OutputStream out) {

        Node node = client.getNode(path);

        try ( PrintWriter pw = new PrintWriter(out)) {

            if (node instanceof ContainerNode) {
                ContainerNode folder = (ContainerNode) node;
                pw.println("<tbody id=\"nodes\">");
                for (Node child : folder.getNodes().getNode()) {
                    pw.println(getNodeHtml(child));
                }
                pw.println("</tbody>");
            }
        }
    }

    private String getNodeHtml(Node node) {
        String html = "<tr>";
        html += "<td><a href=\"#\">";
        html += getName(node);
        html += "</a></td>";
        html += "</tr>";
        return html;
    }

    private String getName(Node node) {

        String uri = node.getUri();

        String prefix = "vos://" + authority;

        if (!uri.startsWith(prefix)) {
            throw new VOSpaceException("Node authority is different from configured one! Configured is " + authority + ", but node URI is " + uri);
        }

        return uri.substring(prefix.length() + 1);
    }
}
