package it.inaf.ia2.vospace.ui;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SecurityConfig {

    private static final Logger LOG = LoggerFactory.getLogger(SecurityConfig.class);

    @Value("${cors.allowed.origin}")
    private String corsAllowedOrigin;

    /**
     * CORS are necessary only for development (API access from npm server).
     */
    @Bean
    @Profile("dev")
    public WebMvcConfigurer corsConfigurer() {

        return new WebMvcConfigurer() {

            @Override
            public void addCorsMappings(CorsRegistry registry) {

                LOG.warn("Development profile active: CORS filter enabled");

                registry.addMapping("/**")
                        .allowedOrigins(corsAllowedOrigin)
                        .allowedMethods("*")
                        .allowCredentials(true);
            }
        };
    }
}
