/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.service;

import it.inaf.ia2.aa.data.User;
import java.util.List;
import net.ivoa.xml.vospace.v2.LinkNode;
import net.ivoa.xml.vospace.v2.Node;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MoveOrCopyNodeModalHtmlGenerator extends NodesHtmlGenerator {

    private final List<String> targetNodes;

    public MoveOrCopyNodeModalHtmlGenerator(Node node, List<String> targetNodes, User user, String authority, List<Node> linkedNodes) {
        super(node, user, authority, linkedNodes);
        this.targetNodes = targetNodes;
    }

    @Override
    protected Element createContainerElement(Document html) {
        Element container = html.body().appendElement("div");
        container.attr("id", "move-or-copy-nodes");
        container.attr("class", "list-group");
        return container;
    }

    @Override
    protected void addChild(Node child, Element containerElement) {

        Node linkedNode = null;
        if (child instanceof LinkNode) {
            linkedNode = getLinkedNode(child);
            if (linkedNode == null) {
                // linked node is a file
                return;
            }
        }

        NodeInfo nodeInfo = new NodeInfo(child, user, authority, linkedNode);

        if (!nodeInfo.isFolder() || targetNodes.contains(nodeInfo.getPath())) {
            return;
        }

        Element row = containerElement.appendElement("div");
        row.addClass("list-group-item");

        addNodeIcon(nodeInfo, row);
        addLink(nodeInfo, row);
    }

    private void addLink(NodeInfo nodeInfo, Element cell) {
        Element link = cell.appendElement("a");
        link.attr("href", "#");
        link.attr("onclick", "openNodeInMoveOrCopyModal(event, " + makeJsArg(nodeInfo.getPath()) + ")");
        link.text(nodeInfo.getName());
    }
}
