/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.aa.ServletRapClient;
import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest
@AutoConfigureMockMvc(addFilters = false)
@TestPropertySource(properties = {"vospace-authority=example.com!vospace"})
public class DownloadControllerTest {

    @MockBean
    private VOSpaceClient client;

    @MockBean
    private ServletRapClient rapClient;

    @Autowired
    private MockMvc mockMvc;

    @Test
    public void testDirectDownload() throws Exception {

        when(client.getFileServiceEndpoint(any())).thenReturn("http://redirect");

        mockMvc.perform(get("/download/myfile"))
                .andExpect(status().is3xxRedirection());

        verify(client, times(1)).getFileServiceEndpoint(any());
    }

    @Test
    public void testDownloadJobResult() throws Exception {

        User user = mock(User.class);
        when(user.getAccessToken()).thenReturn("<token>");

        when(client.getArchiveJobHref("job123")).thenReturn("http://file-service/job123.zip");

        when(rapClient.exchangeToken(any(), any())).thenReturn("<new-token>");

        String redirect = mockMvc.perform(get("/download?jobId=job123")
                .principal(user))
                .andExpect(status().is3xxRedirection())
                .andReturn().getResponse().getRedirectedUrl();

        assertEquals("http://file-service/job123.zip?token=<new-token>", redirect);
    }
}
