/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.data.SharingInfo;
import it.inaf.ia2.vospace.ui.service.SharingService;
import org.junit.jupiter.api.Test;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest
@AutoConfigureMockMvc
public class SharingControllerTest {

    @MockBean
    private SharingService service;

    @Autowired
    private MockMvc mockMvc;

    @Test
    public void testListNodesEmpty() throws Exception {

        when(service.getSharingInfo()).thenReturn(new SharingInfo());

        mockMvc.perform(get("/sharing"))
                .andExpect(status().isOk());

        verify(service, times(1)).getSharingInfo();
    }
}
