/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.service;

import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.datamodel.NodeProperties;
import java.util.Arrays;
import java.util.List;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.LinkNode;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.Test;

public class NodesHtmlGeneratorTest {

    @Test
    public void testGenerateNodes() {

        ContainerNode parent = new ContainerNode();
        parent.setUri("vos://example.com!vospace/mynode");
        setGroups(parent, "group1", "group1");

        DataNode file1 = new DataNode();
        file1.setUri("vos://example.com!vospace/mynode/file1");
        setGroups(file1, "group1", "group2 people.name\\.surname");
        parent.getNodes().add(file1);

        LinkNode link1 = new LinkNode();
        link1.setUri("vos://example.com!vospace/mynode/link1");
        link1.setTarget("vos://example.com!vospace/mynode");
        setGroups(link1, "group1", "group2 people.name\\.surname");
        parent.getNodes().add(link1);

        LinkNode link2 = new LinkNode();
        link2.setUri("vos://example.com!vospace/mynode/link2");
        link2.setTarget("vos://example.com!vospace/mynode/file1");
        setGroups(link2, "group1", "group2 people.name\\.surname");
        parent.getNodes().add(link2);

        LinkNode link3 = new LinkNode();
        link3.setUri("vos://example.com!vospace/mynode/link3");
        link3.setTarget("http://external-link");
        setGroups(link3, "group1", "group2 people.name\\.surname");
        parent.getNodes().add(link3);

        List<Node> linkedNodes = List.of(parent, file1);

        User user = new User();
        user.setUserId("user_id");
        user.setGroups(Arrays.asList("group1", "group2"));

        MainNodesHtmlGenerator generator = new MainNodesHtmlGenerator(parent, user, "example.com!vospace", linkedNodes);

        String html = generator.generateNodes();

        System.out.println(html);

        assertTrue(html.startsWith("<tbody id=\"nodes\">"));
        assertTrue(html.contains("<input type=\"checkbox\" data-node=\"/mynode/file1\" class=\"deletable\">"));
        assertTrue(html.contains("<span class=\"icon folder-link-icon\"></span>&nbsp;<a href=\"#/nodes/mynode\">link1</a>"));
        assertTrue(html.contains("<span class=\"icon link-icon\"></span>&nbsp;<a target=\"blank_\" href=\"download/mynode/link2\">link2</a>"));
        assertTrue(html.contains("<span class=\"icon file-icon\"></span>&nbsp;<a target=\"blank_\" href=\"download/mynode/link3\">link3</a>"));
    }

    private void setGroups(Node node, String groupRead, String groupWrite) {
        Property groupReadProperty = new Property();
        groupReadProperty.setUri(NodeProperties.GROUP_READ_URI);
        groupReadProperty.setValue(groupRead);

        Property groupWriteProperty = new Property();
        groupWriteProperty.setUri(NodeProperties.GROUP_WRITE_URI);
        groupWriteProperty.setValue(groupWrite);

        node.getProperties().add(groupReadProperty);
        node.getProperties().add(groupWriteProperty);
    }
}
