/* Vuex store, for centralized state management */

import Vue from 'vue';
import Vuex from 'vuex';
import client from 'api-client';
import main from './main';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    path: '',
    loading: true,
    tapeButtonEnabled: false,
    jobs: [],
    user: 'anonymous'
  },
  mutations: {
    setLoading(state, loading) {
      state.loading = loading;
    },
    setPath(state, value) {
      if (!value) {
        value = '';
      }
      state.path = value;
    },
    setTapeButtonEnabled(state, value) {
      state.tapeButtonEnabled = value;
    },
    setJobs(state, jobs) {
      // empty the array
      state.jobs.splice(0, jobs.length);
      // fill again
      for (let i = 0; i < jobs.length; i++) {
        state.jobs.push(jobs[i]);
      }
    },
    addJob(state, job) {
      state.jobs.push(job);
    },
    setUsername(state, username) {
      state.user = username;
    }
  },
  actions: {
    setPath({ state, commit, dispatch }, path) {
      commit('setPath', path);
      client.getNode(state.path)
        .then(res => {
          document.getElementById('nodes').outerHTML = res;
          let checkboxes = document.querySelectorAll('#nodes input[type="checkbox"]');
          for (let i = 0; i < checkboxes.length; i++) {
            checkboxes[i].addEventListener('change', function() {
              dispatch('computeButtonVisibility');
            });
          }
          dispatch('computeButtonVisibility');
        });
    },
    computeButtonVisibility({ commit }) {
      commit('setTapeButtonEnabled', document.querySelectorAll('#nodes input.tape:checked').length > 0);
    },
    startRecallFromTapeJob({ commit }) {
      let tapeCheckboxes = document.querySelectorAll('#nodes input:checked'); // temporary: it should be input.tape
      let paths = [];
      for (let i = 0; i < tapeCheckboxes.length; i++) {
        paths.push(tapeCheckboxes[i].getAttribute('data-node'));
      }
      client.startRecallFromTapeJob(paths)
        .then(job => {
          main.showInfo('Job started');
          commit('addJob', job);
        });
    },
    loadJobs({ commit }) {
      client.loadJobs()
        .then(jobs => commit('setJobs', jobs));
    },
    loadUserInfo({ commit }) {
      client.getUserInfo()
        .then(res => commit('setUsername', res.username));
    },
    createFolder({ state, dispatch }, newFolderName) {
      client.createFolder(state.path, newFolderName)
        .then(() => {
          // Reload current node
          dispatch('setPath', state.path);
        });
    },
    uploadFiles({ state, dispatch }, files) {
      let names = [];
      for (let file of files) {
        names.push(file.name);
      }
      client.prepareForUpload(state.path, names)
        .then(uploadUrls => {
          for (let i = 0; i < files.length; i++) {
            client.uploadFile(uploadUrls[i], files[i]);
          }
        })
        .then(() => {
          // Reload current node
          dispatch('setPath', state.path);
        });
    }
  }
});
