package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import it.inaf.ia2.vospace.ui.service.NodesService;
import javax.servlet.http.HttpServletRequest;
import net.ivoa.xml.vospace.v2.Protocol;
import net.ivoa.xml.vospace.v2.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NodesController {

    @Value("${vospace-authority}")
    private String authority;

    @Autowired
    private NodesService nodesService;

    @Autowired
    private VOSpaceClient client;

    @Autowired
    private HttpServletRequest servletRequest;

    /**
     * This is the only API endpoint that returns HTML code instead of JSON. The
     * reason is that JavaScript frameworks are not very efficient in handling
     * very long lists and tables, so this part of the code is generated
     * server-side. The content type is set to text/plain even if it is an HTML
     * fragment to avoid browser parsing issues since it is not a complete HTML
     * document.
     */
    @GetMapping(value = {"/nodes", "/nodes/**"}, produces = MediaType.TEXT_PLAIN_VALUE)
    public String listNodes() throws Exception {

        String path = getPath("/nodes/");

        return nodesService.generateNodesHtml(path);
    }

    @GetMapping(value = "/download/**")
    public ResponseEntity<?> directDownload() {

        String path = getPath("/download/");

        Transfer transfer = new Transfer();
        transfer.setDirection("pullFromVoSpace");
        transfer.setTarget("vos://" + authority + path);

        Protocol protocol = new Protocol();
        protocol.setUri("ivo://ivoa.net/vospace/core#httpget");
        transfer.getProtocols().add(protocol);

        String url = client.getDownloadEndpoints(transfer).get(0).getEndpoint();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Location", url);
        return new ResponseEntity<>(headers, HttpStatus.SEE_OTHER);
    }

    /**
     * Slash is a special character in defining REST endpoints and trying to
     * define a PathVariable containing slashes doesn't work, so the endpoint
     * has been defined using "/nodes/**" instead of "/nodes/{path}" and the
     * path is extracted manually parsing the request URL.
     */
    protected String getPath(String prefix) {
        String requestURL = servletRequest.getRequestURL().toString();
        String[] split = requestURL.split(prefix);

        String path = "/";
        if (split.length == 2) {
            path += split[1];
        }
        return path;
    }
}
