/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.vospace.ui.TokenProvider;
import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import it.inaf.oats.vospace.datamodel.collections.NodeCollectionsWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NodeCollectionsController extends BaseController {
    
    private static final Logger LOG = LoggerFactory.getLogger(NodeCollectionsController.class);
    
    @Autowired
    private VOSpaceClient client;
    
    @Autowired
    private TokenProvider tokenProvider;
    
    @GetMapping(value = "/collections", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<NodeCollectionsWrapper> listNodeCollections(User principal) 
            throws Exception
    {
        LOG.debug("listNodeCollections called for user {}", principal.getName());
        
        NodeCollectionsWrapper ncw =
                client.getNodeCollections(tokenProvider.getToken());
        
        return ResponseEntity.ok(ncw);
    }
    
}
