/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.data;

/**
 * Represents the result of the operations necessary before uploading a file
 * (node metadata creation and generation of pushToVoSpace upload URL). If one
 * of these operations fails the UI shows the error message for the specific
 * file involved in the failure rather than aborting the whole upload (that can
 * be composed by multiple files).
 */
public class PreUploadResult {

    private String url;
    private String error;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }
}
