package it.inaf.ia2.vospace.ui;

import java.util.concurrent.ForkJoinPool;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class VOSpaceUiApplication {

    public static void main(String[] args) {
        SpringApplication.run(VOSpaceUiApplication.class, args);
    }

    /**
     * Solves a ClassLoader issue. See class JaxbForkJoinWorkerThreadFactory.
     */
    public static ForkJoinPool getJaxbExecutor() {
        JaxbForkJoinWorkerThreadFactory threadFactory = new JaxbForkJoinWorkerThreadFactory();
        int parallelism = Math.min(0x7fff /* copied from ForkJoinPool.java */, Runtime.getRuntime().availableProcessors());
        return new ForkJoinPool(parallelism, threadFactory, null, false);
    }
}
