/* Vuex store, for centralized state management */

import Vue from 'vue';
import Vuex from 'vuex';
import client from 'api-client';
import main from './main';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    path: '',
    loading: true,
    tapeButtonEnabled: false
  },
  mutations: {
    setLoading(state, loading) {
      state.loading = loading;
    },
    setPath(state, value) {
      if (!value) {
        value = '';
      }
      state.path = value;
    },
    setTapeButtonEnabled(state, value) {
      state.tapeButtonEnabled = value;
    }
  },
  actions: {
    setPath({ state, commit, dispatch }, path) {
      commit('setPath', path);
      client.getNode(state.path)
        .then(res => {
          document.getElementById('nodes').outerHTML = res;
          let checkboxes = document.querySelectorAll('#nodes input[type="checkbox"]');
          for (let i = 0; i < checkboxes.length; i++) {
            checkboxes[i].addEventListener('change', function() {
              dispatch('computeButtonVisibility');
            });
          }
          dispatch('computeButtonVisibility');
        });
    },
    computeButtonVisibility({ commit }) {
      commit('setTapeButtonEnabled', document.querySelectorAll('#nodes input.tape:checked').length > 0);
    },
    startRecallFromTapeJob() {
      let tapeCheckboxes = document.querySelectorAll('#nodes input.tape:checked');
      let paths = [];
      for (let i = 0; i < tapeCheckboxes.length; i++) {
        paths.push(tapeCheckboxes[i].getAttribute('data-node'));
      }
      client.startRecallFromTapeJob(paths)
        .then(() => {
          main.showInfo('Job started');
        });
    }
  }
});
