package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import it.inaf.ia2.vospace.ui.data.ListNodeData;
import it.inaf.ia2.vospace.ui.service.NodesService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.Property;
import net.ivoa.xml.vospace.v2.Protocol;
import net.ivoa.xml.vospace.v2.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NodesController extends BaseController {

    @Value("${vospace-authority}")
    private String authority;

    @Autowired
    private NodesService nodesService;

    @Autowired
    private VOSpaceClient client;

    @Autowired
    private HttpServletRequest servletRequest;

    @GetMapping(value = {"/nodes", "/nodes/**"}, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<ListNodeData> listNodes(User principal) throws Exception {

        String path = getPath("/nodes/");

        return ResponseEntity.ok(nodesService.generateNodesHtml(path, principal));
    }

    @DeleteMapping(value = {"/nodes", "/nodes/**"})
    public void deleteNode() {
        String path = getPath("/nodes/");
        client.deleteNode(path);
    }
    
    @GetMapping(value = "/download/**")
    public ResponseEntity<?> directDownload() {

        String path = getPath("/download/");

        Transfer transfer = new Transfer();
        transfer.setDirection("pullFromVoSpace");
        transfer.setTarget("vos://" + authority + path);

        Protocol protocol = new Protocol();
        protocol.setUri("ivo://ivoa.net/vospace/core#httpget");
        transfer.getProtocols().add(protocol);

        String url = client.getFileServiceEndpoints(transfer).get(0).getEndpoint();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Location", url);
        return new ResponseEntity<>(headers, HttpStatus.SEE_OTHER);
    }

    @PostMapping(value = "/folder")
    public void newFolder(@RequestBody Map<String, Object> params) {

        String parentPath = getRequiredParam(params, "parentPath");
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        String name = getRequiredParam(params, "name");

        ContainerNode node = new ContainerNode();
        node.setUri("vos://" + authority + parentPath + "/" + name);
        
        Property creator = new Property();
        creator.setUri("ivo://ivoa.net/vospace/core#creator");
        creator.setValue(getUser().getName());
        node.getProperties().add(creator);

        client.createNode(node);
    }

    /**
     * Slash is a special character in defining REST endpoints and trying to
     * define a PathVariable containing slashes doesn't work, so the endpoint
     * has been defined using "/nodes/**" instead of "/nodes/{path}" and the
     * path is extracted manually parsing the request URL.
     */
    protected String getPath(String prefix) {
        String requestURL = servletRequest.getRequestURL().toString();
        String[] split = requestURL.split(prefix);

        String path = "/";
        if (split.length == 2) {
            path += split[1];
        }
        return path;
    }
}
