package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.service.NodesService;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.verify;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest
@AutoConfigureMockMvc
public class NodesControllerTest {

    @MockBean
    private NodesService nodesService;

    @Autowired
    private MockMvc mockMvc;
    
    @Test
    public void testListNodesEmpty() throws Exception {

        mockMvc.perform(get("/nodes"))
                .andExpect(status().isOk());

        verify(nodesService).generateNodesHtml(eq("/"), any());
    }

    @Test
    public void testListNodesRoot() throws Exception {

        mockMvc.perform(get("/nodes/"))
                .andExpect(status().isOk());

        verify(nodesService).generateNodesHtml(eq("/"), any());
    }

    @Test
    public void testListNodesComplexPath() throws Exception {

        mockMvc.perform(get("/nodes/a/b/c"))
                .andExpect(status().isOk());

        verify(nodesService).generateNodesHtml(eq("/a/b/c"), any());
    }
}
