package it.inaf.ia2.vospace.ui.data;

import java.text.SimpleDateFormat;
import javax.xml.datatype.XMLGregorianCalendar;
import net.ivoa.xml.uws.v1.ExecutionPhase;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.uws.v1.ShortJobDescription;

public class Job {

    private String id;
    private String creationTime;
    private ExecutionPhase phase;
    private boolean read;

    public Job() {
    }

    public Job(JobSummary job) {
        this.id = job.getJobId();
        this.creationTime = formatCreationTime(job.getCreationTime());
        this.phase = job.getPhase();
    }

    public Job(ShortJobDescription job) {
        this.id = job.getId();
        this.creationTime = formatCreationTime(job.getCreationTime());
        this.phase = job.getPhase();
    }

    private String formatCreationTime(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(calendar.toGregorianCalendar().getTime());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public ExecutionPhase getPhase() {
        return phase;
    }

    public void setPhase(ExecutionPhase phase) {
        this.phase = phase;
    }

    public boolean isRead() {
        return read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }
}
