package it.inaf.ia2.vospace.ui.service;

import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;

public class NodeInfoTest {

    private static final String AUTHORITY = "example.com!vospace";

    @Test
    public void testZero() {
        testNodeLength(0, "0 B");
    }

    @Test
    public void testSizeBytes() {
        testNodeLength(5, "5 B");
    }

    @Test
    public void testSizeKilo() {
        testNodeLength(1024, "1.0 KB");
    }

    @Test
    public void testSizeMega() {
        testNodeLength(149639144, "142.7 MB");
    }

    @Test
    public void testSizeGiga() {
        testNodeLength(483286324544L, "450.1 GB");
    }

    @Test
    public void testSizeTera() {
        testNodeLength(6963696737140L, "6.3 TB");
    }

    @Test
    public void testSizePeta() {
        testNodeLength(6963696737150000L, "6.2 PB");
    }

    private void testNodeLength(long bytes, String expectedText) {
        DataNode node = getDataNode();
        setLength(node, bytes);
        NodeInfo nodeInfo = new NodeInfo(node, AUTHORITY);
        assertEquals(expectedText, nodeInfo.getSize());
    }

    private DataNode getDataNode() {
        DataNode node = new DataNode();
        node.setUri("vos://example.com!vospace/mynode");
        return node;
    }

    private void setLength(Node node, long length) {
        Property lengthProperty = new Property();
        lengthProperty.setUri("ivo://ivoa.net/vospace/core#length");
        lengthProperty.setValue(String.valueOf(length));
        node.getProperties().add(lengthProperty);
    }
}
