import Vue from 'vue'
import App from './App.vue'
import store from './store.js'
import './plugins/bootstrap-vue'

import { BootstrapVue } from 'bootstrap-vue'

Vue.use(BootstrapVue)
Vue.config.productionTip = false

import VueRouter from 'vue-router'
Vue.use(VueRouter)
import router from './router.js'

let vm = new Vue({
  render: h => h(App),
  store,
  router
}).$mount('#app')

window.deleteNode = function(path) {
  store.commit('setNodesToDelete', [path]);
  vm.$bvModal.show('confirm-delete-modal');
}

export default {
  showError(message) {
    vm.$bvToast.toast(message, {
      title: 'Error',
      variant: 'danger',
      solid: true
    });
  },
  showInfo(message) {
    vm.$bvToast.toast(message, {
      title: 'Info',
      variant: 'info',
      solid: true
    });
  }
}
