/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui;

import it.inaf.ia2.aa.data.User;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenProvider {

    @Autowired
    private HttpServletRequest request;

    public Optional<String> getToken() {

        HttpSession session = request.getSession(false);
        if (session != null) {
            User user = (User) session.getAttribute("user_data");
            if (user != null) {
                return Optional.of(user.getAccessToken());
            }
        }
        return Optional.empty();
    }
}
