package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import it.inaf.ia2.vospace.ui.data.Job;
import java.util.ArrayList;
import java.util.List;
import net.ivoa.xml.uws.v1.ExecutionPhase;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.vospace.v2.Protocol;
import net.ivoa.xml.vospace.v2.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JobController {

    @Value("${vospace-authority}")
    private String authority;

    @Autowired
    private VOSpaceClient client;

    @PostMapping(value = "/recall", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Job> startRecallFromTapeJob(@RequestBody List<String> paths) {

        if (paths.size() != 1) {
            throw new UnsupportedOperationException();
        }

        Transfer transfer = new Transfer();
        transfer.setDirection("pullToVoSpace");
        transfer.setTarget("vos://" + authority + paths.get(0));
        Protocol protocol = new Protocol();
        protocol.setUri("ia2:tape-recall");
        transfer.getProtocol().add(protocol);

        JobSummary job = client.startTransferJob(transfer);

        if (job.getPhase() == ExecutionPhase.QUEUED) {
            return ResponseEntity.ok(new Job(job));
        }
        // TODO: proper handling
        throw new RuntimeException("Error while executing job " + job.getJobId() + ". Job phase is " + job.getPhase() + ". QUEUED expected");
    }

    @GetMapping(value = "/jobs", produces = MediaType.APPLICATION_JSON_VALUE)
    public List<Job> getJobs() {
        // TODO
        return new ArrayList<>();
    }
}
