package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.service.NodesService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NodesController {

    @Autowired
    private NodesService nodesService;

    /**
     * This is the only API endpoint that returns HTML code instead of JSON. The
     * reason is that JavaScript frameworks are not very efficient in handling
     * very long lists and tables, so this part of the code is generated
     * server-side. The content type is set to text/plain even if it is an HTML
     * fragment to avoid browser parsing issues since it is not a complete HTML
     * document.
     */
    @GetMapping(value = {"/nodes", "/nodes/**"}, produces = MediaType.TEXT_PLAIN_VALUE)
    public String listNodes(HttpServletRequest request) throws Exception {

        String requestURL = request.getRequestURL().toString();
        String[] split = requestURL.split("/nodes/");

        String path = "/";
        if (split.length == 2) {
            path += split[1];
        }

        return nodesService.generateNodesHtml(path);
    }

    @GetMapping(value = "/download/{path}")
    public void directDownload(@PathVariable("path") String path) {
        // TODO: call pullFromVoSpace sync transfer
    }
}
