package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import java.util.Collections;
import net.ivoa.xml.uws.v1.ExecutionPhase;
import net.ivoa.xml.uws.v1.JobSummary;
import net.ivoa.xml.vospace.v2.Protocol;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.argThat;
import static org.mockito.Mockito.when;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.web.client.RestTemplate;

@SpringBootTest
@AutoConfigureMockMvc
@TestPropertySource(properties = {"vospace-authority=example.com!vospace"})
public class JobControllerTest {

    @MockBean
    private VOSpaceClient client;

    @MockBean
    private RestTemplate restTemplate;
    
    @Autowired
    private MockMvc mockMvc;

    @Test
    public void testSingleFileAsyncRecall() throws Exception {

        JobSummary job = new JobSummary();
        job.setPhase(ExecutionPhase.QUEUED);

        when(client.startTransferJob(any())).thenReturn(job);

        mockMvc.perform(post("/recall")
                .contentType(MediaType.APPLICATION_JSON)
                .content("[\"/path/to/file\"]"))
                .andExpect(status().isOk());
    }

    @Test
    public void testMultipleFilesAsyncRecall() throws Exception {

        JobSummary job = new JobSummary();
        job.setPhase(ExecutionPhase.QUEUED);

        when(client.startTransferJob(argThat(transfer -> {
            return transfer.getTarget().startsWith("vos://example.com!vospace/path/to/.tmp-");
        }))).thenReturn(job);

        Protocol protocol = new Protocol();
        protocol.setEndpoint("http://file-service/path/to/file");

        when(client.getFileServiceEndpoints(any())).thenReturn(Collections.singletonList(protocol));

        mockMvc.perform(post("/recall")
                .contentType(MediaType.APPLICATION_JSON)
                .content("[\"/path/to/file1\", \"/path/to/file2\"]"))
                .andExpect(status().isOk());
    }
}
