package it.inaf.ia2.vospace.ui.service;

import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.datamodel.NodeProperties;
import java.util.Arrays;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.Test;

public class NodesHtmlGeneratorTest {

    @Test
    public void testGenerateNodes() {

        ContainerNode parent = new ContainerNode();
        parent.setUri("vos://example.com!vospace/mynode");
        setGroups(parent, "group1", "group1");

        DataNode file1 = new DataNode();
        file1.setUri("vos://example.com!vospace/mynode/file1");
        setGroups(file1, "group1", "group2 people.name\\.surname");
        parent.getNodes().add(file1);

        User user = new User();
        user.setUserId("user_id");
        user.setGroups(Arrays.asList("group1", "group2"));

        NodesHtmlGenerator generator = new NodesHtmlGenerator(parent, user, "example.com!vospace");

        String html = generator.generateNodes();

        System.out.println(html);

        assertTrue(html.startsWith("<tbody id=\"nodes\">"));
        assertTrue(html.contains("<input type=\"checkbox\" data-node=\"/mynode/file1\" class=\"deletable\">"));
    }

    private void setGroups(Node node, String groupRead, String groupWrite) {
        Property groupReadProperty = new Property();
        groupReadProperty.setUri(NodeProperties.GROUP_READ_URI);
        groupReadProperty.setValue(groupRead);

        Property groupWriteProperty = new Property();
        groupWriteProperty.setUri(NodeProperties.GROUP_WRITE_URI);
        groupWriteProperty.setValue(groupWrite);

        node.getProperties().add(groupReadProperty);
        node.getProperties().add(groupWriteProperty);
    }
}
