package it.inaf.ia2.vospace.ui.service;

import it.inaf.ia2.vospace.ui.client.VOSpaceClient;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import net.ivoa.xml.vospace.v2.ContainerNode;
import net.ivoa.xml.vospace.v2.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NodesService {

    private static final Logger LOG = LoggerFactory.getLogger(NodesService.class);

    @Autowired
    private VOSpaceClient client;

    @Value("${vospace-authority}")
    private String authority;

    public String generateNodesHtml(String path) {

        Node node = client.getNode(path);

        try ( StringWriter sw = new StringWriter()) {

            if (node instanceof ContainerNode) {
                ContainerNode folder = (ContainerNode) node;
                sw.write("<tbody id=\"nodes\">");
                for (Node child : folder.getNodes()) {
                    sw.write(getNodeHtml(child));
                }
                sw.write("</tbody>");
            }

            return sw.toString();
        } catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String getNodeHtml(Node node) {

        NodeInfo nodeInfo = new NodeInfo(node, authority);

        String html = "<tr>";
        html += "<td><input type=\"checkbox\" data-node=\"" + nodeInfo.getPath() + "\" /></td>";
        html += "<td>" + getIcon(nodeInfo) + getLink(nodeInfo) + "</td>";
        html += "<td>" + nodeInfo.getSize() + "</td>";
        html += "<td>" + nodeInfo.getGroupRead() + "</td>";
        html += "<td>" + nodeInfo.getGroupWrite() + "</td>";
        html += "</tr>";
        return html;
    }

    private String getIcon(NodeInfo nodeInfo) {
        String html = "<span class=\"icon ";
        if ("vos:ContainerNode".equals(nodeInfo.getType())) {
            html += "folder";
        } else {
            html += "file";
        }
        html += "-icon\"></span>&nbsp;";
        return html;
    }

    private String getLink(NodeInfo nodeInfo) {
        if (isDownloadable(nodeInfo)) {
            if ("vos:ContainerNode".equals(nodeInfo.getType())) {
                return "<a href=\"#/nodes" + nodeInfo.getPath() + "\">" + nodeInfo.getName() + "</a>";
            } else {
                return "<a href=\"download" + nodeInfo.getPath() + "\" target=\"blank_\">" + nodeInfo.getName() + "</a>";
            }
        }
        return nodeInfo.getName();
    }

    private boolean isDownloadable(NodeInfo nodeInfo) {
        if (nodeInfo.isPublic()) {
            return true;
        }
        // TODO: check user group
        return true; // temporary always true
    }
}
