/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.STCS;
import adql.parser.ParseException;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.translator.H2Translator;
import adql.translator.TranslationException;

public class AstroH2Translator
extends H2Translator {
    public AstroH2Translator() {
    }

    public AstroH2Translator(boolean allCaseSensitive) {
        super(allCaseSensitive);
    }

    public AstroH2Translator(boolean catalog, boolean schema, boolean table, boolean column) {
        super(catalog, schema, table, column);
    }

    @Override
    public String translate(ExtractCoord fct) throws TranslationException {
        return fct.getName().equalsIgnoreCase("COORD1") ? "coord1(" + this.translate(fct.getParameter(0)) + ")" : "coord2(" + this.translate(fct.getParameter(0)) + ")";
    }

    @Override
    public String translate(ExtractCoordSys fct) throws TranslationException {
        return "''";
    }

    @Override
    public String translate(AreaFunction fct) throws TranslationException {
        return "area(" + this.translate(fct.getParameter(0)) + ")";
    }

    @Override
    public String translate(CentroidFunction fct) throws TranslationException {
        return "centroid(" + this.translate(fct.getParameter(0)) + ")";
    }

    @Override
    public String translate(DistanceFunction fct) throws TranslationException {
        return "distance(" + this.translate(fct.getP1()) + "," + this.translate(fct.getP2()) + ")";
    }

    @Override
    public String translate(ContainsFunction fct) throws TranslationException {
        return "contains(" + this.translate(fct.getLeftParam()) + "," + this.translate(fct.getRightParam()) + ")";
    }

    @Override
    public String translate(IntersectsFunction fct) throws TranslationException {
        return "intersects(" + this.translate(fct.getLeftParam()) + "," + this.translate(fct.getRightParam()) + ")";
    }

    @Override
    public String translate(PointFunction fct) throws TranslationException {
        return "point(" + this.translate(fct.getCoord1()) + "," + this.translate(fct.getCoord2()) + ")";
    }

    @Override
    public String translate(CircleFunction fct) throws TranslationException {
        return "circle(" + this.translate(fct.getCoord1()) + "," + this.translate(fct.getCoord2()) + "," + this.translate(fct.getRadius()) + ")";
    }

    @Override
    public String translate(BoxFunction fct) throws TranslationException {
        return "box(" + this.translate(fct.getCoord1()) + "," + this.translate(fct.getCoord2()) + "," + this.translate(fct.getWidth()) + "," + this.translate(fct.getHeight()) + ")";
    }

    @Override
    public String translate(PolygonFunction fct) throws TranslationException {
        throw new TranslationException("Polygons not yet supported! Sorry :(");
    }

    @Override
    public String translate(RegionFunction fct) throws TranslationException {
        try {
            STCS.Region region = STCS.parseRegion((String)fct.getParameter(0).toString());
            switch (region.type) {
                case POSITION: {
                    return "point(" + region.coordinates[0][0] + "," + region.coordinates[0][1] + ")";
                }
                case CIRCLE: {
                    return "circle(" + region.coordinates[0][0] + "," + region.coordinates[0][1] + "," + region.radius + ")";
                }
                case BOX: {
                    return "box(" + region.coordinates[0][0] + "," + region.coordinates[0][1] + "," + region.width + "," + region.height + ")";
                }
                case POLYGON: {
                    throw new TranslationException("Polygons not yet supported! Sorry :(");
                }
            }
            throw new TranslationException("STCS regions of type " + region.type + " not supported!");
        }
        catch (ParseException pe) {
            throw new TranslationException((Throwable)pe);
        }
    }

    @Override
    public STCS.Region translateGeometryFromDB(Object obj) throws ParseException {
        return super.translateGeometryFromDB(obj);
    }

    @Override
    public Object translateGeometryToDB(STCS.Region region) throws ParseException {
        return super.translateGeometryToDB(region);
    }
}

