/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class InteriorPointPoint {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public InteriorPointPoint(Geometry g) {
        this.centroid = g.getCentroid().getCoordinate();
        this.add(g);
    }

    private void add(Geometry geom) {
        if (geom instanceof Point) {
            this.add(geom.getCoordinate());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.add(gc.getGeometryN(i));
                ++i;
            }
        }
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }
}

