/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.util.ArrayList;
import java.util.List;

public class IndexedNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
        this.totalEnv.expandToInclude(ring.getEnvelopeInternal());
    }

    public boolean isNonNested() {
        this.buildIndex();
        int i = 0;
        while (i < this.rings.size()) {
            LinearRing innerRing = (LinearRing)this.rings.get(i);
            Coordinate[] innerRingPts = innerRing.getCoordinates();
            List results = this.index.query(innerRing.getEnvelopeInternal());
            int j = 0;
            while (j < results.size()) {
                boolean isInside;
                Coordinate innerRingPt;
                LinearRing searchRing = (LinearRing)results.get(j);
                Coordinate[] searchRingPts = searchRing.getCoordinates();
                if (innerRing != searchRing && innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal()) && (innerRingPt = IsValidOp.findPtNotNode(innerRingPts, searchRing, this.graph)) != null && (isInside = CGAlgorithms.isPointInRing(innerRingPt, searchRingPts))) {
                    this.nestedPt = innerRingPt;
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void buildIndex() {
        this.index = new STRtree();
        int i = 0;
        while (i < this.rings.size()) {
            LinearRing ring = (LinearRing)this.rings.get(i);
            Envelope env = ring.getEnvelopeInternal();
            this.index.insert(env, ring);
            ++i;
        }
    }
}

