/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import com.vividsolutions.jts.simplify.VWLineSimplifier;

public class VWSimplifier {
    private Geometry inputGeom;
    private double distanceTolerance;
    private boolean isEnsureValidTopology = true;

    public static Geometry simplify(Geometry geom, double distanceTolerance) {
        VWSimplifier simp = new VWSimplifier(geom);
        simp.setDistanceTolerance(distanceTolerance);
        return simp.getResultGeometry();
    }

    public VWSimplifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be non-negative");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public void setEnsureValid(boolean isEnsureValidTopology) {
        this.isEnsureValidTopology = isEnsureValidTopology;
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return (Geometry)this.inputGeom.clone();
        }
        return new VWTransformer(this.isEnsureValidTopology).transform(this.inputGeom);
    }

    class VWTransformer
    extends GeometryTransformer {
        private boolean isEnsureValidTopology = true;

        public VWTransformer(boolean isEnsureValidTopology) {
            this.isEnsureValidTopology = isEnsureValidTopology;
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = null;
            newPts = inputPts.length == 0 ? new Coordinate[]{} : VWLineSimplifier.simplify(inputPts, VWSimplifier.this.distanceTolerance);
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            if (geom.isEmpty()) {
                return null;
            }
            Geometry rawGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                return rawGeom;
            }
            return this.createValidArea(rawGeom);
        }

        protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
            boolean removeDegenerateRings = parent instanceof Polygon;
            Geometry simpResult = super.transformLinearRing(geom, parent);
            if (removeDegenerateRings && !(simpResult instanceof LinearRing)) {
                return null;
            }
            return simpResult;
        }

        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry rawGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(rawGeom);
        }

        private Geometry createValidArea(Geometry rawAreaGeom) {
            if (this.isEnsureValidTopology) {
                return rawAreaGeom.buffer(0.0);
            }
            return rawAreaGeom;
        }
    }
}

