/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.SavotField;
import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.BitInterpreter;
import cds.savot.model.interpreter.BooleanInterpreter;
import cds.savot.model.interpreter.CharInterpreter;
import cds.savot.model.interpreter.DoubleComplexInterpreter;
import cds.savot.model.interpreter.DoubleInterpreter;
import cds.savot.model.interpreter.FloatComplexInterpreter;
import cds.savot.model.interpreter.FloatInterpreter;
import cds.savot.model.interpreter.IntegerInterpreter;
import cds.savot.model.interpreter.LongInterpreter;
import cds.savot.model.interpreter.ShortInterpreter;
import cds.savot.model.interpreter.UnicodeCharInterpreter;
import cds.savot.model.interpreter.UnsignedByteInterpreter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;

public abstract class BinaryFieldInterpreter<T> {
    protected final String TYPE_LABEL;
    protected final int NB_BYTES;
    protected final IntegerInterpreter arraySizeInterpreter;
    protected final int[] fixArraySizes;
    protected final int nbItems;
    protected String strNullValue = "";
    protected String arraySeparator = " ";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BinaryFieldInterpreter(int[] arraysizes, String typeLabel, int nbBytes) throws BinaryInterpreterException {
        this.TYPE_LABEL = typeLabel == null || typeLabel.trim().isEmpty() ? "byte" : typeLabel.trim();
        this.NB_BYTES = nbBytes <= 0 ? 1 : nbBytes;
        int nbItems = 0;
        this.fixArraySizes = new int[arraysizes.length];
        int i = 0;
        while (i < arraysizes.length) {
            if (arraysizes[i] <= 0) {
                if (i != arraysizes.length - 1) throw new BinaryInterpreterException("Incorrect arraysize: only the last dimension of an array can be variable in length !");
                this.fixArraySizes[i] = -1;
                nbItems = -1;
            } else {
                this.fixArraySizes[i] = arraysizes[i];
                nbItems += arraysizes[i];
            }
            ++i;
        }
        this.nbItems = nbItems <= 0 ? -1 : nbItems;
        this.arraySizeInterpreter = this.nbItems != -1 ? null : new IntegerInterpreter();
    }

    public T[] decode(InputStream input) throws IOException {
        int arraysize = this.getArraySize(input);
        if (arraysize == -1) {
            return null;
        }
        byte[] bytes = this.readBytes(input, arraysize);
        if (bytes == null) {
            if (this.arraySizeInterpreter == null) {
                return null;
            }
            throw new BinaryInterpreterException("Unexpected EOF: " + arraysize + " items of type " + this.TYPE_LABEL + " should be read !");
        }
        T[] decoded = this.createEmptyArray(arraysize);
        int i = 0;
        while (i < arraysize) {
            decoded[i] = this.decodePrimary(bytes, i * this.NB_BYTES);
            ++i;
        }
        return decoded;
    }

    protected int getArraySize(InputStream input) throws IOException {
        if (this.arraySizeInterpreter != null) {
            Integer[] ints = (Integer[])this.arraySizeInterpreter.decode(input);
            if (ints == null) {
                return -1;
            }
            return ints[0];
        }
        return this.nbItems;
    }

    protected byte[] readBytes(InputStream input, int length) throws IOException {
        if (length < 0) {
            throw new NegativeArraySizeException("Impossible to get negative number of " + this.TYPE_LABEL + " !");
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.NB_BYTES * length];
        int nbRead = input.read(bytes);
        if (nbRead == bytes.length) {
            return bytes;
        }
        if (nbRead == -1) {
            return null;
        }
        if (nbRead % this.NB_BYTES == 0) {
            throw new BinaryInterpreterException("Unexpected EOF: can not get " + length + " value of type " + this.TYPE_LABEL + " ! (" + nbRead / this.NB_BYTES + " items successfully read)");
        }
        throw new BinaryInterpreterException("Unexpected EOF: can not get a full " + this.TYPE_LABEL + " (= " + this.NB_BYTES + " bytes) ! (" + nbRead / this.NB_BYTES + " items successfully read)");
    }

    public String convertToString(Object cellValue) {
        if (cellValue == null) {
            return null;
        }
        if (cellValue.getClass().isArray()) {
            Object[] array = (Object[])cellValue;
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    str.append(this.arraySeparator);
                }
                str.append(this.convertToString(array[i]));
                ++i;
            }
            return str.toString();
        }
        if (cellValue.toString().equals(this.strNullValue)) {
            return null;
        }
        return cellValue.toString();
    }

    protected T[] createEmptyArray(int arraysize) throws ClassCastException, NegativeArraySizeException {
        return this.getArrayClass().cast(Array.newInstance(this.getArrayClass().getComponentType(), arraysize));
    }

    protected abstract Class<T[]> getArrayClass();

    public abstract T decodePrimary(byte[] var1, int var2) throws BinaryInterpreterException;

    public void encode(OutputStream output, Object value) throws IOException, BinaryInterpreterException {
        boolean encodeInArray;
        boolean variableArray = this.nbItems < 0;
        boolean bl = encodeInArray = variableArray || this.nbItems > 1;
        if (value != null && value.getClass().isArray() && !encodeInArray) {
            throw new BinaryInterpreterException("Impossible to encode an array into a single " + this.TYPE_LABEL + " !");
        }
        ArrayList<T> values = new ArrayList<T>(this.convertIntoArray(value));
        if (variableArray) {
            this.arraySizeInterpreter.encode(output, values.size());
        } else if (values.size() > this.nbItems) {
            throw new BinaryInterpreterException("The given array is bigger than the arraysize set by the savot field: " + values.size() + " > " + this.nbItems + " !");
        }
        int i = 0;
        while (i < values.size()) {
            output.write(this.encodePrimary(values.get(i)));
            ++i;
        }
        if (values.size() < this.nbItems) {
            output.write(this.getPadding(this.nbItems - values.size()));
        }
    }

    public byte[] getPadding(int length) {
        return new byte[length];
    }

    public final byte[] getPadding() {
        return this.getPadding(this.NB_BYTES);
    }

    protected ArrayList<T> convertIntoArray(Object value) throws BinaryInterpreterException {
        ArrayList<T> list = new ArrayList<T>();
        if (value == null) {
            list.add(this.convertPrimary(value));
            return list;
        }
        if (value instanceof String) {
            String str = (String)value;
            String[] values = new String[]{};
            if (this.arraySeparator == null || this.arraySeparator.isEmpty()) {
                values = new String[str.length()];
                int i = 0;
                while (i < values.length) {
                    values[i] = String.valueOf(str.charAt(i));
                    ++i;
                }
            } else {
                values = str.split(this.arraySeparator);
            }
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (v == null || v.equalsIgnoreCase(this.strNullValue)) {
                    list.add(null);
                } else {
                    list.add(this.convertPrimary(v));
                }
                ++n2;
            }
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            int i = 0;
            while (i < array.length) {
                list.addAll(this.convertIntoArray(array[i]));
                ++i;
            }
        } else {
            list.add(this.convertPrimary(value));
        }
        return list;
    }

    protected abstract T convertPrimary(Object var1) throws BinaryInterpreterException;

    public abstract byte[] encodePrimary(T var1) throws BinaryInterpreterException;

    public static final BinaryFieldInterpreter<?> createInterpreter(SavotField field) throws BinaryInterpreterException {
        BinaryFieldInterpreter interpreter;
        int[] arraysizes;
        String type = field.getDataType();
        if (type == null) {
            type = "";
        }
        if (field.getArraySize().trim().isEmpty()) {
            arraysizes = new int[]{1};
        } else {
            String[] sizesStr = field.getArraySize().trim().split("x");
            arraysizes = new int[sizesStr.length];
            int i = 0;
            while (i < sizesStr.length) {
                if (sizesStr[i].endsWith("*")) {
                    arraysizes[i] = -1;
                } else {
                    try {
                        arraysizes[i] = Integer.parseInt(sizesStr[i]);
                        if (arraysizes[i] <= 0) {
                            System.err.println("Warning: an array-size must be positive and non-null => \"" + arraysizes[i] + "\" in the array-size \"" + field.getArraySize() + "\" of \"" + field.getName() + "\" will be considered as variable !");
                            arraysizes[i] = -1;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        arraysizes[i] = -1;
                        System.err.println("Warning: undefined array-size \"" + sizesStr[i] + "\" (in \"" + field.getArraySize() + "\") for \"" + field.getName() + "\". Supposed to be \"*\".");
                    }
                }
                if (arraysizes[i] == -1 && i != sizesStr.length - 1) {
                    arraysizes = new int[]{-1};
                    System.err.println("Warning: incorrect arraysize syntax \"" + field.getArraySize() + "\" for \"" + field.getName() + "\". Only the last dimension can be variable in length ! This field will be considered as an array of \"" + field.getDataType() + "\" with only one dimension variable in length.");
                    break;
                }
                ++i;
            }
        }
        if (type.equalsIgnoreCase("boolean")) {
            interpreter = new BooleanInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("bit")) {
            interpreter = new BitInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("unsignedByte")) {
            interpreter = new UnsignedByteInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("char")) {
            interpreter = new CharInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("unicodeChar")) {
            interpreter = new UnicodeCharInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("short")) {
            interpreter = new ShortInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("int")) {
            interpreter = new IntegerInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("long")) {
            interpreter = new LongInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("float")) {
            interpreter = new FloatInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("double")) {
            interpreter = new DoubleInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("floatComplex")) {
            interpreter = new FloatComplexInterpreter(arraysizes);
        } else if (type.equalsIgnoreCase("doubleComplex")) {
            interpreter = new DoubleComplexInterpreter(arraysizes);
        } else {
            System.err.println("Warning: missing type attribute for \"" + field.getName() + "\". Supposed to be char(" + BinaryFieldInterpreter.arraySizeToString(arraysizes) + ") !");
            interpreter = new CharInterpreter(arraysizes);
        }
        if (field.getValues() != null && field.getValues().getNull() != null && !field.getValues().getNull().equalsIgnoreCase(interpreter.arraySeparator)) {
            interpreter.strNullValue = field.getValues().getNull();
        }
        return interpreter;
    }

    public static final String arraySizeToString(int[] arraysize) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < arraysize.length) {
            if (i > 0) {
                str.append('x');
            }
            if (arraysize[i] <= 0) {
                str.append('*');
            } else {
                str.append(arraysize[i]);
            }
            ++i;
        }
        return str.toString();
    }
}

