/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.CharInterpreter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class BitInterpreter
extends CharInterpreter {
    public BitInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "bit array", 1);
    }

    public Character[] decode(InputStream input) throws IOException, BinaryInterpreterException {
        int arraysize = this.getArraySize(input);
        int nbBytes = arraysize / 8;
        if (arraysize % 8 > 0) {
            ++nbBytes;
        }
        byte[] bytes = this.readBytes(input, nbBytes);
        Character[] decoded = (Character[])this.createEmptyArray(arraysize);
        int indBit = 0;
        int i = 0;
        while (i < nbBytes && indBit < arraysize) {
            byte b = bytes[i];
            int j = 0;
            while (j < 8 && indBit < arraysize) {
                char c = (char)((0x80 & b << j) >>> 7 | 0x30);
                decoded[indBit] = Character.valueOf(c);
                ++j;
                ++indBit;
            }
            ++i;
        }
        return decoded;
    }

    @Override
    public Character decodePrimary(byte[] bytes, int offset) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Class<Character[]> getArrayClass() {
        return Character[].class;
    }

    @Override
    protected Character convertPrimary(Object value) throws BinaryInterpreterException {
        if (value != null && value instanceof Boolean) {
            return Character.valueOf((Boolean)value != false ? (char)'1' : '0');
        }
        char c = super.convertPrimary(value).charValue();
        if (c != '0' && c != '1') {
            throw new BinaryInterpreterException("Incorrect bit value: \"" + c + "\" !");
        }
        return Character.valueOf(c);
    }

    @Override
    public void encode(OutputStream output, Object value) throws IOException, BinaryInterpreterException {
        boolean variableArray = this.nbItems < 0;
        boolean encodeInArray = variableArray || this.nbItems > 1;
        ArrayList<Object> values = new ArrayList<Object>();
        if (value.getClass().isArray()) {
            if (!encodeInArray) {
                throw new BinaryInterpreterException("Impossible to encode an array into a single " + this.TYPE_LABEL + " !");
            }
            values.addAll(this.convertIntoArray((Object[])value));
        } else {
            values.add(this.convertPrimary(value));
        }
        if (variableArray) {
            this.arraySizeInterpreter.encode(output, values.size());
        } else if (values.size() > this.nbItems) {
            throw new BinaryInterpreterException("The given array is bigger than the arraysize set by the savot field: " + values.size() + " > " + this.nbItems + " !");
        }
        int nbBytes = 0;
        if (this.nbItems > 0) {
            nbBytes = this.nbItems / 8;
            if (this.nbItems % 8 > 0) {
                ++nbBytes;
            }
        } else {
            nbBytes = values.size() / 8;
            if (values.size() % 8 > 0) {
                ++nbBytes;
            }
        }
        byte[] bytes = new byte[nbBytes];
        int b = 0;
        while (b < nbBytes) {
            bytes[b] = 0;
            int i = 0;
            int v = b * 8;
            while (i < 8 && v < values.size()) {
                char c = ((Character)values.get(v)).charValue();
                switch (c) {
                    case '1': {
                        int n = b;
                        bytes[n] = (byte)(bytes[n] | (byte)(1 << 7 - i));
                        break;
                    }
                    case '0': {
                        break;
                    }
                    default: {
                        throw new BinaryInterpreterException("Incorrect bit value: " + c);
                    }
                }
                ++i;
                ++v;
            }
            ++b;
        }
        output.write(bytes);
    }

    @Override
    public byte[] encodePrimary(Character value) throws BinaryInterpreterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getPadding(int length) {
        throw new UnsupportedOperationException();
    }
}

