/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;

public class CharInterpreter
extends BinaryFieldInterpreter<Character> {
    public CharInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        this(arraysizes, "character", 1);
    }

    public CharInterpreter(int[] arraysizes, String typeLabel, int nbBytes) throws BinaryInterpreterException {
        super(arraysizes, "character", 1);
        this.arraySeparator = "";
    }

    @Override
    public Character decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        return Character.valueOf((char)(b[offset] & 0xFF));
    }

    @Override
    protected Class<Character[]> getArrayClass() {
        return Character[].class;
    }

    @Override
    protected Character convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return Character.valueOf('\u0000');
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() > 1) {
                throw new BinaryInterpreterException("Impossible to convert into a single " + this.TYPE_LABEL + " a String which contains " + str.length() + " characters !");
            }
            if (str.isEmpty()) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(str.charAt(0));
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into a " + this.TYPE_LABEL + " !");
    }

    @Override
    public byte[] encodePrimary(Character value) throws BinaryInterpreterException {
        if (value == null) {
            return this.getPadding();
        }
        return new byte[]{(byte)value.charValue()};
    }
}

