/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.DoubleInterpreter;
import java.util.ArrayList;

public class DoubleComplexInterpreter
extends BinaryFieldInterpreter<Double[]> {
    private final DoubleInterpreter doubleDecoder = new DoubleInterpreter();

    public DoubleComplexInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "double complex", 16);
    }

    @Override
    public Double[] decodePrimary(byte[] bytes, int offset) throws BinaryInterpreterException {
        Double[] complex = new Double[]{this.doubleDecoder.decodePrimary(bytes, offset), this.doubleDecoder.decodePrimary(bytes, offset + this.NB_BYTES / 2)};
        if (complex[0] == null || complex[0] == Double.NaN || complex[1] == null || complex[1] == Double.NaN) {
            complex = new Double[2];
        }
        return complex;
    }

    @Override
    protected Class<Double[][]> getArrayClass() {
        return Double[][].class;
    }

    @Override
    protected ArrayList<Double[]> convertIntoArray(Object value) throws BinaryInterpreterException {
        ArrayList doubles = this.doubleDecoder.convertIntoArray(value);
        if (doubles.size() % 2 > 0) {
            throw new BinaryInterpreterException("Bad number of double values (" + doubles.size() + "): not a factor of 2 ! Note: a Double Complex is composed of 2 double values.");
        }
        ArrayList<Double[]> list = new ArrayList<Double[]>();
        int i = 0;
        while (i + 1 < doubles.size()) {
            list.add(new Double[]{(Double)doubles.get(i), (Double)doubles.get(i + 1)});
            i += 2;
        }
        return list;
    }

    @Override
    protected Double[] convertPrimary(Object value) throws BinaryInterpreterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] encodePrimary(Double[] value) throws BinaryInterpreterException {
        if (value.length % 2 > 0) {
            throw new BinaryInterpreterException("Bad number of double values: a Double Complex is composed of 2 double values !");
        }
        byte[] encoded = new byte[2 * this.doubleDecoder.NB_BYTES];
        int i = 0;
        while (i < 2) {
            byte[] bytes = this.doubleDecoder.encodePrimary(value[i]);
            int b = 0;
            while (b < this.doubleDecoder.NB_BYTES) {
                encoded[i * 8 + b] = bytes[b];
                ++b;
            }
            ++i;
        }
        return encoded;
    }
}

