/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.FloatInterpreter;
import java.util.ArrayList;

public class FloatComplexInterpreter
extends BinaryFieldInterpreter<Float[]> {
    private final FloatInterpreter floatDecoder = new FloatInterpreter();

    public FloatComplexInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "float complex", 8);
    }

    @Override
    public Float[] decodePrimary(byte[] bytes, int offset) throws BinaryInterpreterException {
        Float[] complex = new Float[]{this.floatDecoder.decodePrimary(bytes, offset), this.floatDecoder.decodePrimary(bytes, offset + this.NB_BYTES / 2)};
        if (complex[0] == null || complex[0].floatValue() == Float.NaN || complex[1] == null || complex[1].floatValue() == Float.NaN) {
            complex = new Float[]{Float.valueOf(Float.NaN), Float.valueOf(Float.NaN)};
        }
        return complex;
    }

    @Override
    protected Class<Float[][]> getArrayClass() {
        return Float[][].class;
    }

    @Override
    protected ArrayList<Float[]> convertIntoArray(Object value) throws BinaryInterpreterException {
        ArrayList floats = this.floatDecoder.convertIntoArray(value);
        if (floats.size() % 2 > 0) {
            throw new BinaryInterpreterException("Bad number of float values (" + floats.size() + "): not a factor of 2 ! Note: a Float Complex is composed of 2 float values.");
        }
        ArrayList<Float[]> list = new ArrayList<Float[]>();
        int i = 0;
        while (i + 1 < floats.size()) {
            list.add(new Float[]{(Float)floats.get(i), (Float)floats.get(i + 1)});
            i += 2;
        }
        return list;
    }

    @Override
    protected Float[] convertPrimary(Object value) throws BinaryInterpreterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] encodePrimary(Float[] value) throws BinaryInterpreterException {
        if (value.length % 2 > 0) {
            throw new BinaryInterpreterException("Bad number of float values: a Float Complex is composed of 2 float values !");
        }
        byte[] encoded = new byte[2 * this.floatDecoder.NB_BYTES];
        int i = 0;
        while (i < 2) {
            byte[] bytes = this.floatDecoder.encodePrimary(value[i]);
            int b = 0;
            while (b < this.floatDecoder.NB_BYTES) {
                encoded[i * 8 + b] = bytes[b];
                ++b;
            }
            ++i;
        }
        return encoded;
    }
}

